<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>频点设置</title>
<link rel="stylesheet" type="text/css" href="../style/default.css" />
<script type="text/javascript" src="../js/jquery-1.8.3.min.js"></script>
<script type="text/javascript" src="../js/smsx_common.js"></script>
<script type="text/javascript" src="../js/card_ch_config.js"></script>
<style type="text/css">
.body_width
{
	width: 500px;
}
.tab_width
{
	width: 480px;
}
.tableContainer input
{
	width: 98%;
	width: 97%\9;
	text-align: center;
}
.tableContainer select
{
	width: 100px;
}
.button_area_special
{
	width: 220px;
}
</style>
</head>

<body>
<input type="hidden" id="language" value="1" />
<div class="body_div body_width">
  <div class="table_tab_div">
    <div class="table_tab_left"></div>
    <div class="table_tab tab_width">频点设置</div>
    <div class="table_tab_right"></div>
  </div>
  <div class="tableContainer">
    <table cellpadding="0" cellspacing="0" style="width:100%;" id="ch_config_table">
      <tbody>
        <tr>
          <th width="240px;">频点</th>
          <td id="channel" title="设置频点" style="border-top:0"></td>
        </tr>
        <tr>
          <th>频率值(MHz)</th>
          <td id="centre_freq" title="范围：48~996"></td>
        </tr>
        <tr>
          <th>调制模式</th>
          <td>
            <select id="modulation" tabindex="1" title="频点的调制模式" onchange="ModulationChange(this);">
            </select>
          </td>
        </tr>
        <tr>
          <th>符号率(Mbaud)</th>
          <td>
            <input id="symbol_rate" type="text" tabindex="2" title="频点的符号率(ITU-A: 3.500-7.000)" onkeyup="EnableApply();" onchange="SymbolRateChange(this)" />
          </td>
        </tr>
        <tr>
          <th>带宽</th>
          <td>
            <select id="bandwidth" tabindex="3" title="频点的带宽" onchange="BWChange(this);">
              <option value="8">8</option>
              <option value="6">6</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>交织</th>
          <td>
            <select id="interleaving" title="频点的交织模式" onchange="interleavingChange(this);">
              <option value="1">128,1</option>
              <option value="2">128,2</option>
              <option value="3">64,2</option>
              <option value="4">128,3</option>
              <option value="5">32,4</option>
              <option value="6">128,4</option>
              <option value="7">16,8</option>
              <option value="8">128,5</option>
              <option value="9">8,16</option>
              <option value="10">128,6</option>
              <option value="12">128,7</option>
              <option value="14">128,8</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>频点模式</th>
          <td>
            <select id="channel_mode" tabindex="3" title="频点的信号模式" onchange="ModeChange(this);">
              <option value="1">正常</option>
              <option value="4">反转</option>
              <option value="0">关闭</option>
              <option value="2">载波</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>传送流ID</th>
          <td>
            <input id="transport_id" type="text" tabindex="4" maxlength="5" title="频点的传送流ID(0 - 65535)" onkeyup="EnableApply();" onchange="TansportIdChange(this)" />
          </td>
        </tr>
        <tr>
          <th>业务管理</th>
          <td>
            <select id="qam_manager" tabindex="6" title="频点的应用类型" onchange="ManagerChange(this);">
              <option value="0">VOD</option>
              <option value="1">Broadcast</option>
              <option value="2">S_VOD</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>组名</th>
          <td>
            <input id="qam_group_name" type="text" tabindex="7" maxlength="20" title="频点的组名" onkeyup="EnableApply();" onchange="GroupNameChange(this)" />
          </td>
        </tr>
        <tr>
          <th>衰减</th>
          <td>
            <input id="atten" type="text" tabindex="8" maxlength="6" title="频点的衰减(0 - 65)" onkeyup="EnableApply();" onchange="AttenChange(this)" />
          </td>
        </tr>
        <tr>
          <th>DTS调整</th>
          <td>
            <select id="dts_adjust" tabindex="9" title="频点的DTS调整" onchange="DtsAdjustChange(this);">
              <option value="1">是</option>
              <option value="0">否</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>SDV</th>
          <td>
            <select id="sdv_support" tabindex="10" title="频点是否支持SDV" onchange="SdvSupportChange(this);">
              <option value="1">是</option>
              <option value="0">否</option>
            </select>
          </td>
        </tr>
        <tr>
          <th>动态UDP起始值</th>
          <td>
            <input id="starting_udp_port" type="text" tabindex="11" maxlength="5" title="频点的动态UDP起始值(0 - 65535)" onkeyup="EnableApply();" onchange="StartUdpPortChange(this)" />
          </td>
        </tr>
      </tbody>
    </table>
  </div>
  <div id="psiInterval" style="display: none;">
    <div class="table_tab_div">
      <div class="table_tab_left"></div>
      <div class="table_tab tab_width">频点PSI/SI表间隔</div>
      <div class="table_tab_right"></div>
    </div>
    <div class="button_div">
      <div class="button_area button_area_special">
        <input type="button" value="清零" id="Clear" onclick="goClear();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
        <input style="width:130px;background: url(../images/btn3_normal.png)" type="button" value="恢复默认值" id="Default" onclick="goDefault();this.style.background = 'url(../images/btn2_normal.png)';"
			hidefocus="true" onmouseover="mouseOverSpec(this);" onmouseout="mouseOutSpec(this);" />
      </div>
    </div>
    <div class="tableContainer">
      <table cellpadding="0" cellspacing="0" style="width:100%;">
        <tr>
          <th width="240px;">PAT表间隔(ms)</th>
          <td style="border-top:0">
            <input id="pat_interval" type="text" tabindex="12" maxlength="5" size="15" title="频点的PAT表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 0)" />
          </td>
        </tr>
        <tr>
          <th>PMT表间隔(ms)</th>
          <td>
            <input id="pmt_interval" type="text" tabindex="13" maxlength="5" size="15" title="频点的PMT表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 1)" />
          </td>
        </tr>
        <tr>
          <th>NIT(当前流)表间隔(ms)</th>
          <td>
            <input id="nit_c_interval" type="text" tabindex="14" maxlength="5" size="15" title="频点的NIT(当前流)表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 2)" />
          </td>
        </tr>
        <tr>
          <th>NIT(其它流)表间隔(ms)</th>
          <td>
            <input id="nit_o_interval" type="text" tabindex="15" maxlength="5" size="15" title="频点的NIT(其它流)表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 3)" />
          </td>
        </tr>
        <tr>
          <th>SDT(当前流)表间隔(ms)</th>
          <td>
            <input id="sdt_c_interval" type="text" tabindex="16" maxlength="5" size="15" title="频点的SDT(当前流)表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 4)" />
          </td>
        </tr>
        <tr>
          <th>SDT(其它流)表间隔(ms)</th>
          <td>
            <input id="sdt_o_interval" type="text" tabindex="17" maxlength="5" size="15" title="频点的SDT(其它流)表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 5)" />
          </td>
        </tr>
        <tr>
          <th>BAT表间隔(ms)</th>
          <td>
            <input id="bat_interval" type="text" tabindex="18" maxlength="5" size="15" title="频点的BAT表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 6)" />
          </td>
        </tr>
        <tr>
          <th>CAT表间隔(ms)</th>
          <td>
            <input id="cat_interval" type="text" tabindex="19" maxlength="5" size="15" title="频点的CAT表间隔" onkeyup ="EnableApply();" onchange="IntervalChange(this, 7)" />
          </td>
        </tr>
      </table>
    </div>
  </div>
  <div class="button">
    <input type="button" style="margin-left:176px;" value="设置" id="Apply" onclick="QamChannelApply();this.style.background = 'url(../images/btn2_normal.png)';"
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
    <input type="button" style="margin-left:8px;" value="刷新" id="Reset" onclick="QamChannelReload();this.style.background = 'url(../images/btn2_normal.png)';" 
		hidefocus="true" onmouseover="mouseOverNormal(this);" onmouseout="mouseOutNormal(this);" />
  </div>
</div>
</body>
</html>